function newSsm = copySsm(oldSsm)
%COPYSSM Make a copy of a given StateSpaceModel object
%   Usage: newSsm = copySsm(oldSsm)
%   oldSsm - an existing StateSpaceModel object
%   newSsm - a new StateSpaceModel object, with identical properties

% David Katzin, Wageningen University
% david.katzin@wur.nl

    [stateNames, auxNames, ctrlNames, paramNames, inputNames] = getFieldNames(oldSsm);

    newSsm = StateSpaceModel();
    newSsm.t = DynamicElement(oldSsm.t);
	
    for k=1:length(stateNames)
        newSsm.x.(stateNames{k}) = DynamicElement(oldSsm.x.(stateNames{k}));
    end
    
    for k=1:length(auxNames)
        newSsm.a.(auxNames{k}) = DynamicElement(oldSsm.a.(auxNames{k}));
    end
    
     for k=1:length(ctrlNames)
        newSsm.u.(ctrlNames{k}) = DynamicElement(oldSsm.u.(ctrlNames{k}));
    end
   
    for k=1:length(paramNames)
        newSsm.p.(paramNames{k}) = DynamicElement(oldSsm.p.(paramNames{k}));
    end
    
    for k=1:length(inputNames)
        newSsm.d.(inputNames{k}) = DynamicElement(oldSsm.d.(inputNames{k}));
    end
    newSsm.c = oldSsm.c;
    newSsm.g = oldSsm.g;
end


